/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.ModbusSlaveException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.TCPMasterConnection;

public class ModbusTCPTransaction
implements ModbusTransaction {
    private static int c_TransactionID = 0;
    private TCPMasterConnection m_Connection;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private boolean m_Reconnecting = false;
    private int m_Retries = 3;

    public ModbusTCPTransaction() {
    }

    public ModbusTCPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusTCPTransaction(TCPMasterConnection con) {
        this.setConnection(con);
    }

    public void setConnection(TCPMasterConnection con) {
        this.m_Connection = con;
        this.m_IO = con.getModbusTransport();
    }

    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    public int getTransactionID() {
        return c_TransactionID;
    }

    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    public void setReconnecting(boolean b) {
        this.m_Reconnecting = b;
    }

    public boolean isReconnecting() {
        return this.m_Reconnecting;
    }

    public int getRetries() {
        return this.m_Retries;
    }

    public void setRetries(int num) {
        this.m_Retries = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        if (!this.m_Connection.isConnected()) {
            try {
                this.m_Connection.connect();
            }
            catch (Exception ex) {
                throw new ModbusIOException("Connecting failed.");
            }
        }
        for (int retryCounter = 0; retryCounter <= this.m_Retries; ++retryCounter) {
            try {
                ModbusTransport modbusTransport = this.m_IO;
                synchronized (modbusTransport) {
                    this.m_IO.writeMessage(this.m_Request);
                    this.m_Response = this.m_IO.readResponse();
                    break;
                }
            }
            catch (ModbusIOException ex) {
                if (retryCounter != this.m_Retries) continue;
                throw new ModbusIOException("Executing transaction failed (tried " + this.m_Retries + " times)");
            }
        }
        if (this.m_Response instanceof ExceptionResponse) {
            throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
        }
        if (this.isReconnecting()) {
            this.m_Connection.close();
        }
        if (this.isCheckingValidity()) {
            this.checkValidity();
        }
        this.toggleTransactionID();
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_Connection == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    private void checkValidity() throws ModbusException {
    }

    private void toggleTransactionID() {
        if (this.isCheckingValidity()) {
            c_TransactionID = c_TransactionID == 65534 ? 0 : ++c_TransactionID;
        }
        this.m_Request.setTransactionID(this.getTransactionID());
    }
}

