/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.IllegalFunctionRequest;
import net.wimpi.modbus.msg.ModbusMessageImpl;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsRequest;
import net.wimpi.modbus.msg.ReadInputDiscretesRequest;
import net.wimpi.modbus.msg.ReadInputRegistersRequest;
import net.wimpi.modbus.msg.ReadMultipleRegistersRequest;
import net.wimpi.modbus.msg.WriteCoilRequest;
import net.wimpi.modbus.msg.WriteMultipleCoilsRequest;
import net.wimpi.modbus.msg.WriteMultipleRegistersRequest;
import net.wimpi.modbus.msg.WriteSingleRegisterRequest;

public abstract class ModbusRequest
extends ModbusMessageImpl {
    public abstract ModbusResponse createResponse();

    public ModbusResponse createExceptionResponse(int EXCEPTION_CODE) {
        ExceptionResponse response = new ExceptionResponse(this.getFunctionCode(), EXCEPTION_CODE);
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        return response;
    }

    public static ModbusRequest createModbusRequest(int functionCode) {
        ModbusRequest request = null;
        switch (functionCode) {
            case 3: {
                request = new ReadMultipleRegistersRequest();
                break;
            }
            case 2: {
                request = new ReadInputDiscretesRequest();
                break;
            }
            case 4: {
                request = new ReadInputRegistersRequest();
                break;
            }
            case 1: {
                request = new ReadCoilsRequest();
                break;
            }
            case 16: {
                request = new WriteMultipleRegistersRequest();
                break;
            }
            case 6: {
                request = new WriteSingleRegisterRequest();
                break;
            }
            case 5: {
                request = new WriteCoilRequest();
                break;
            }
            case 15: {
                request = new WriteMultipleCoilsRequest();
                break;
            }
            default: {
                request = new IllegalFunctionRequest(functionCode);
            }
        }
        return request;
    }
}

