/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImageFactory;

public final class ReadInputRegistersResponse
extends ModbusResponse {
    private int m_ByteCount;
    private InputRegister[] m_Registers;

    public ReadInputRegistersResponse() {
    }

    public ReadInputRegistersResponse(InputRegister[] registers) {
        this.m_ByteCount = registers.length * 2;
        this.m_Registers = registers;
        this.setDataLength(this.m_ByteCount + 1);
    }

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public int getWordCount() {
        return this.m_ByteCount / 2;
    }

    private void setByteCount(int count) {
        this.m_ByteCount = count;
    }

    public InputRegister getRegister(int index) throws IndexOutOfBoundsException {
        if (index >= this.getWordCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_Registers[index];
    }

    public int getRegisterValue(int index) throws IndexOutOfBoundsException {
        if (index >= this.getWordCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_Registers[index].toUnsignedShort();
    }

    public InputRegister[] getRegisters() {
        return this.m_Registers;
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeByte(this.m_ByteCount);
        for (int k = 0; k < this.getWordCount(); ++k) {
            dout.write(this.m_Registers[k].toBytes());
        }
    }

    public void readData(DataInput din) throws IOException {
        this.setByteCount(din.readUnsignedByte());
        InputRegister[] registers = new InputRegister[this.getWordCount()];
        ProcessImageFactory pimf = ModbusCoupler.getReference().getProcessImageFactory();
        for (int k = 0; k < this.getWordCount(); ++k) {
            registers[k] = pimf.createInputRegister(din.readByte(), din.readByte());
        }
        this.m_Registers = registers;
        this.setDataLength(this.getByteCount() + 1);
    }
}

