/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import net.wimpi.modbus.util.LinkedNode;

public class LinkedQueue {
    protected LinkedNode m_Head;
    protected final Object m_PutLock = new Object();
    protected LinkedNode m_Tail = this.m_Head = new LinkedNode(null);
    protected int m_WaitingForTake = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) {
        Object object = this.m_PutLock;
        synchronized (object) {
            LinkedNode p = new LinkedNode(x);
            LinkedNode linkedNode = this.m_Tail;
            synchronized (linkedNode) {
                this.m_Tail.m_NextNode = p;
                this.m_Tail = p;
            }
            if (this.m_WaitingForTake > 0) {
                this.m_PutLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object extract() {
        LinkedNode linkedNode = this.m_Head;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.m_Head.m_NextNode;
            if (first != null) {
                x = first.m_Node;
                first.m_Node = null;
                this.m_Head = first;
            }
            return x;
        }
    }

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
        return true;
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.m_PutLock;
        synchronized (object) {
            try {
                ++this.m_WaitingForTake;
                while (true) {
                    if ((x = this.extract()) != null) {
                        --this.m_WaitingForTake;
                        return x;
                    }
                    this.m_PutLock.wait();
                }
            }
            catch (InterruptedException ex) {
                --this.m_WaitingForTake;
                this.m_PutLock.notify();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        LinkedNode linkedNode = this.m_Head;
        synchronized (linkedNode) {
            LinkedNode first = this.m_Head.m_NextNode;
            if (first != null) {
                return first.m_Node;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedNode linkedNode = this.m_Head;
        synchronized (linkedNode) {
            return this.m_Head.m_NextNode == null;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.m_PutLock;
        synchronized (object) {
            try {
                long waitTime = msecs;
                long start = msecs <= 0L ? 0L : System.currentTimeMillis();
                ++this.m_WaitingForTake;
                while (true) {
                    if ((x = this.extract()) != null || waitTime <= 0L) {
                        --this.m_WaitingForTake;
                        return x;
                    }
                    this.m_PutLock.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
            }
            catch (InterruptedException ex) {
                --this.m_WaitingForTake;
                this.m_PutLock.notify();
                throw ex;
            }
        }
    }
}

