//---------------------------------------------------------------------------
//
//  ljconsole.c
//  
//  Calls AISample twice to read all 8 single-ended channels.  
//
//	Requires LabJack U12 DLL V1.05 or later.
//
//  support@labjack.com
//  1/2002
//----------------------------------------------------------------------
//

#include <stdio.h>
#include <wtypes.h>
//#include <hidsdi.h>
//#include <hid.h>
//#include <process.h>
//#include <windows.h>
#include "ljackuw.h"


/*

AISample

Reads the voltages from 1,2, or 4 analog inputs.  Also
controls/reads the 4 IO ports.  Execution time for this
function is 20 milliseconds or less.

Declaration:
long __cdecl AISample (	long *idnum,
				long demo,
				long *stateIO,
				long updateIO,
				long ledOn,
				long numChannels,
				long *channels,
				long *gains,
				long disableCal,
				long *overVoltage,
				float *voltages )

Parameter Description:
Returns:	LabJack errorcodes or 0 for no error.
Inputs:
	*idnum - Local ID, serial number, or -1 for first found.
	demo - Send 0 for normal operation, >0 for demo mode.  Demo mode allows this function to be called without a LabJack.
	*stateIO - Output states for IO0-IO3.
	updateIO - If >0, state values will be written.  Otherwise, just a read is performed.
	ledOn - If >0, the LabJack LED is turned on.
	numChannels - Number of analog input channels to read (1,2, or 4).
	*channels - Pointer to an array of channel commands with at least numChannels elements.  Each channel command is 0-7 for single-ended, or 8-11 for differential.
	*gains - Pointer to an array of gain commands with at least numChannels elements.  Gain commands are 0=1, 1=2, , 7=20.  This amplification is only available for differential channels.
	disableCal - If >0, voltages returned will be raw readings that are not corrected using calibration constants.
	*voltages - Pointer to an array where voltage readings are returned.  Send a 4-element array of zeros.
Outputs:
	*idnum - Returns the local ID or -1 if no LabJack is found.
	*overVoltage - If >0, an overvoltage has been detected on one of the selected analog inputs.
	*voltages - Pointer to an array where numChannels voltage readings are returned.

*/



main()
{
	long errorcode;
	long idnum=-1;
	long demo=0;
	long stateIO=0;
	long numCh=4;
	long channels[4]={0,1,2,3};
	long gains[4]={0,0,0,0};
	long ov;
	float voltages[4]={0,0,0,0};

	errorcode = AISample (&idnum,demo,&stateIO,0,1,numCh,channels,gains,0,&ov,voltages);
	printf("\nAISample error = %d\n",errorcode);
	printf("\nLocal ID = %d\n",idnum);
	printf("AI0 = %f\n",voltages[0]);
	printf("AI1 = %f\n",voltages[1]);
	printf("AI2 = %f\n",voltages[2]);
	printf("AI3 = %f\n",voltages[3]);

	channels[0]=4;
	channels[1]=5;
	channels[2]=6;
	channels[3]=7;
	voltages[0]=0;  //must initialize voltages array to zeros
	voltages[1]=0;
	voltages[2]=0;
	voltages[3]=0;
	errorcode = AISample (&idnum,demo,&stateIO,0,1,numCh,channels,gains,0,&ov,voltages);
	printf("\nAISample error = %d\n",errorcode);
	printf("\nLocal ID = %d\n",idnum);
	printf("AI4 = %f\n",voltages[0]);
	printf("AI5 = %f\n",voltages[1]);
	printf("AI6 = %f\n",voltages[2]);
	printf("AI7 = %f\n",voltages[3]);

	printf("\nPress Enter\n");
	getchar();
}
