import com.sun.jna.ptr.IntByReference;
import com.sun.jna.Pointer;
import com.sun.jna.Memory;
import com.labjack.LJM;
import com.labjack.LJMException;

public class LJMUtilities {

	public static void printDeviceInfo(int handle) {
		IntByReference deviceType = new IntByReference(0);
		IntByReference connectionType = new IntByReference(0);
		IntByReference serialNumber = new IntByReference(0);
		IntByReference ipAddress = new IntByReference(0);
		IntByReference port = new IntByReference(0);
		IntByReference maxBytesPerMB = new IntByReference(0);
		
		LJM.getHandleInfo(handle, deviceType, connectionType, serialNumber,
				ipAddress, port, maxBytesPerMB);
		
		Pointer ipStringPtr = new Memory(LJM.Constants.IPv4_STRING_SIZE);
		LJM.numberToIP(ipAddress.getValue(), ipStringPtr);
		
		System.out.println("Opened a LabJack with Device type: "
				+ deviceType.getValue() + ", Connection type: "
				+ connectionType.getValue() + ",");
		System.out.println("  Serial number: " + serialNumber.getValue()
				+ ", IP address: " + ipStringPtr.getString(0) + ", Port: "
				+ port.getValue());
		System.out.println("  Max bytes per MB: " + maxBytesPerMB.getValue());
	}
	
	public LJMUtilities() {}
}