import os
from sendgrid import SendGridAPIClient
from sendgrid.helpers.mail import Mail
from labjack import ljm
from time import sleep 

#Configure email properties (make sure that from_email_addr has undergone Single Sender Verification on SendGrid)
from_email_addr = 'from_email@example.com'
to_email_addr   = 'to@example.com'
email_subject   = 'LABJACK MONITORING ALERT'

#Configure the range that you want the input specified by "name" to remain within
name        = 'AIN0'
low_limit   = 2
high_limit  = 4
delay       = 3

handle = ljm.openS("ANY", "ANY", "ANY")  # Any device, Any connection, Any identifier

alert = False
while not alert:
    result = ljm.eReadName(handle, name) #read the specified input
    print ('Current value of ' + name + ': ' + str(result))

    alert = (result < low_limit) or (result > high_limit)

    if alert:
        message = Mail(
            from_email = from_email_addr,
            to_emails= to_email_addr,
            subject=email_subject,
            html_content= '<strong>ALERT: Value of input ' + name + ' outside of specified range! Current value: '  
                            + str(result) + '</strong>')
        try:
            sg = SendGridAPIClient(os.environ.get('SENDGRID_API_KEY'))
            response = sg.send(message)
            print ('Value outside of range. Email alert sent to: ' + to_email_addr)
        except Exception as e:
            print(e.message)

    sleep(delay)
