"use strict";

module.exports.create = function (options){
	return new Formatter (options);
};

var Formatter = function (options){
	options = options || {};
	this._complete = options.complete || "#";
	this._incomplete = options.incomplete || "·";
	this._length = options.length || 24;
};

Formatter.prototype.format = function (n){
	var bar = "";
	var complete = Math.round (this._length*n);
	for (var i=0; i<complete; i++){
		bar += this._complete;
	}
	for (var i=0; i<this._length-complete; i++){
		bar += this._incomplete;
	}
	return bar;
};