using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace ue9
{
	/// <summary>
	/// Summary description for IPPopUp.
	/// </summary>
	public class IPPopUp : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label dot1;
		private System.Windows.Forms.Label dot3;
		private System.Windows.Forms.Label dot2;		
		private System.Windows.Forms.TextBox ip0;
		private System.Windows.Forms.TextBox ip1;
		private System.Windows.Forms.TextBox ip2;
		private System.Windows.Forms.TextBox ip3;
		private System.Windows.Forms.Button okButton;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.Label enterText;
		
		public string IPAddress = "";

		public IPPopUp()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.enterText = new System.Windows.Forms.Label();
			this.dot1 = new System.Windows.Forms.Label();
			this.dot3 = new System.Windows.Forms.Label();
			this.dot2 = new System.Windows.Forms.Label();
			this.ip3 = new System.Windows.Forms.TextBox();
			this.ip0 = new System.Windows.Forms.TextBox();
			this.ip1 = new System.Windows.Forms.TextBox();
			this.ip2 = new System.Windows.Forms.TextBox();
			this.okButton = new System.Windows.Forms.Button();
			this.cancelButton = new System.Windows.Forms.Button();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			// 
			// enterText
			// 
			this.enterText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.enterText.Location = new System.Drawing.Point(24, 24);
			this.enterText.Size = new System.Drawing.Size(192, 64);
			this.enterText.Text = "Please enter the IP address of the UE9 device you want to connect to.";
			// 
			// dot1
			// 
			this.dot1.Location = new System.Drawing.Point(64, 96);
			this.dot1.Size = new System.Drawing.Size(16, 20);
			this.dot1.Text = ".";
			this.dot1.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// dot3
			// 
			this.dot3.Location = new System.Drawing.Point(160, 96);
			this.dot3.Size = new System.Drawing.Size(16, 20);
			this.dot3.Text = ".";
			this.dot3.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// dot2
			// 
			this.dot2.Location = new System.Drawing.Point(112, 96);
			this.dot2.Size = new System.Drawing.Size(16, 20);
			this.dot2.Text = ".";
			this.dot2.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// ip3
			// 
			this.ip3.Location = new System.Drawing.Point(32, 88);
			this.ip3.MaxLength = 3;
			this.ip3.Size = new System.Drawing.Size(32, 22);
			this.ip3.Text = "192";
			// 
			// ip0
			// 
			this.ip0.Location = new System.Drawing.Point(176, 88);
			this.ip0.MaxLength = 3;
			this.ip0.Size = new System.Drawing.Size(32, 22);
			this.ip0.Text = "209";
			// 
			// ip1
			// 
			this.ip1.Location = new System.Drawing.Point(128, 88);
			this.ip1.MaxLength = 3;
			this.ip1.Size = new System.Drawing.Size(32, 22);
			this.ip1.Text = "1";
			// 
			// ip2
			// 
			this.ip2.Location = new System.Drawing.Point(80, 88);
			this.ip2.MaxLength = 3;
			this.ip2.Size = new System.Drawing.Size(32, 22);
			this.ip2.Text = "168";
			// 
			// okButton
			// 
			this.okButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.okButton.Location = new System.Drawing.Point(40, 136);
			this.okButton.Size = new System.Drawing.Size(72, 24);
			this.okButton.Text = "OK";
			this.okButton.Click += new System.EventHandler(this.okButton_Click);
			// 
			// cancelButton
			// 
			this.cancelButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.cancelButton.Location = new System.Drawing.Point(128, 136);
			this.cancelButton.Size = new System.Drawing.Size(72, 24);
			this.cancelButton.Text = "Cancel";
			this.cancelButton.Click += new System.EventHandler(this.cancelButton_Click);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			// 
			// IPPopUp
			// 
			this.ControlBox = false;
			this.Controls.Add(this.cancelButton);
			this.Controls.Add(this.okButton);
			this.Controls.Add(this.dot1);
			this.Controls.Add(this.dot3);
			this.Controls.Add(this.dot2);
			this.Controls.Add(this.ip3);
			this.Controls.Add(this.ip0);
			this.Controls.Add(this.ip1);
			this.Controls.Add(this.ip2);
			this.Controls.Add(this.enterText);
			this.MaximizeBox = false;
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "Enter IP Address";

		}
		#endregion

		private void okButton_Click(object sender, System.EventArgs e)
		{
			int [] ip = new int[4];

			try
			{
				ip[0] = Convert.ToInt32(ip0.Text);
				ip[1] = Convert.ToInt32(ip1.Text);
				ip[2] = Convert.ToInt32(ip2.Text);
				ip[3] = Convert.ToInt32(ip3.Text);

				for(int i = 0;  i < 4; i++)
				{
					if(ip[i] < 0 || ip[i] > 255)
						throw new Exception();
				}
			}
			catch
			{
				MessageBox.Show("Not a valid IP address.  Please enter a valid IP address.");
				return;
			}

			if(ue9.IPToString(ref IPAddress, ip3.Text, ip2.Text, ip1.Text, ip0.Text) != 0)
			{
				MessageBox.Show("Not a valid IP address.  Please enter a valid IP address.");
				return;
			}

			DialogResult = DialogResult.Yes;
		}

		private void cancelButton_Click(object sender, System.EventArgs e)
		{
			DialogResult = DialogResult.No;
		}
	}
}
