/********************************************************************************************************************************/
// GetDriverVersion
//
// Returns the version number of ljackuw.dll.
//
// Matlab Syntax ->  [version] = GetDriverVersion
//
//		Inputs:
//			none	
//
//		Outputs:
//			version - Version number of ljackuw.dll
// 
/********************************************************************************************************************************/

#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  *out1;
  int i, m, n;
  float version;

  /* Check for proper number of arguments. */
  if(nrhs != 0) 
  {
    mexErrMsgTxt("Input Error --> No inputs required for this function.");
  } 
  else if(nlhs > 1) 
  {
    mexErrMsgTxt("Output Error --> [version]");
  }

  /* Create matrix for the return arguments. */
  plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);

  /* Call the GetDriverVersion function. */
  version = GetDriverVersion();
  
  /* Set Matlab outputs equal to returned LJ values */
  out1[0] = (double)version;
}
