/********************************************************************************************************************************/
// ResetLJ
//
// Causes the LabJack to reset after about 2 seconds.  After resetting the LabJack will re-enumerate. 
//
// MATLAB Syntax:
//		[idnum errorcode] = ResetLJ(idnum)
//
// Input:
//		idnum - Local ID, serial number, or -1 for first found
//
// Output:
//		idnum - Returns the local ID or -1 if no LabJack is found.
//		errorcode - LabJack error codes or 0 for no error.
// 
/********************************************************************************************************************************/

#include "mex.h"
#include "matrix.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  *out1, *out2;
  int i, m, n;
  double inp1;
  long idnum, errorcode;

  /* Check for proper number of arguments. */
  if(nrhs != 1) 
  {
    mexErrMsgTxt("Input Error --> (idnum)");
  } 
  else if(nlhs > 2) 
  {
    mexErrMsgTxt("Output Error --> [idnum errorcode]");
  }

  /* Get dimensions of inputs */
  for (i=0;i<=0;i++)
  {
	 m = mxGetM(prhs[i]);
	 n = mxGetN(prhs[i]);
	 
	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Input must to be scalar");
	 }
  }

  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);

  /* Create matrix for the return arguments. */;
  plhs[0]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[1]= mxCreateDoubleMatrix(1,1,mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);
  out2 = mxGetPr(plhs[1]);

  /* Recast Matlab inputs */
  idnum = long(inp1);

  /* Call the LocalID function. */
  errorcode = Reset(&idnum);
  
  /* Set Matlab outputs equal to returned LJ values */
  out1[0] = (double)idnum;
  out2[0] = (double)errorcode;

}
