//---------------------------------------------------------------------------
//
//  ljcstream.c
//  
//  Simple example starts a stream and reads 250 scans/second from 4 channels
//  for 5 seconds.   
//
//  Requires LabJack U12 DLL V1.05 or later.
//
//  support@labjack.com
//  1/2002
//----------------------------------------------------------------------
//

#include <stdio.h>
#include <wtypes.h>
#include "ljackuw.h"

void initArrays(float (*voltages)[4],long *stateIOout);

main()
{
	long error;
	long id=-1,*idnum=&id;
	long localID=-1;
	long demo=0,numChannels=4,disableCal=0;
	long transferMode=0;
	long channels[4]={0,1,2,3};
	long gains[4]={0,0,0,0};
	float sr=250.0F,*scanRate=&sr;
	long numScans=250,timeout=10;
	float voltages[4096][4]={0.0F};
	long stateIOout[4096]={0};
	long ljb=-1,*ljScanBacklog=&ljb;
	long ov=-1,*overVoltage=&ov;
	long numIts = 5;
	long i;
	long junk;


	id=-1;
	error = AIStreamStart(idnum,demo,0,0,1,numChannels,channels,gains,scanRate,disableCal,0,0);
	localID = *idnum;
	printf("\nAIStreamStart error = %d\n",error);
	printf("Local ID = %d\n",localID);
	i=0;
	while((!error)&&(i<numIts))
	{	
		initArrays(voltages,stateIOout);
		junk=0;
		error = AIStreamRead(localID,numScans,timeout,voltages,stateIOout,0,ljScanBacklog,overVoltage);
		printf("\nAIStreamRead error = %d\n",error);
		printf("1st Scan:  V1=%f, V2=%f,V3=%f, V4=%f\n",voltages[0][0],voltages[0][1],voltages[0][2],voltages[0][3]);
		printf("LabJack Scan Backlog = %d\n\n",*ljScanBacklog);
		i++;
	}
	error = AIStreamClear(localID);
	printf("\nAIStreamClear error = %d\n",error);


	printf("\nPress Enter\n");
	getchar();

}


void initArrays(float (*voltages)[4],long *stateIOout)
{
	long j,k;

	for(j=0;j<4096;j++)
	{
		for(k=0;k<4;k++)
		{
			voltages[j][k]=0.0F;
		}
	}
	for(j=0;j<4096;j++)
	{
		stateIOout[j]=0;
	}

	return;
}