# [LabJack LJM C/C++ Examples](https://labjack.com/support/software/examples/ljm/c)

LabJack's [LJM](https://labjack.com/ljm) C/C++ examples are supported for Windows, Mac, and Linux.

This examples package includes:

- .c/.cpp example programs
- a Python build system for Mac/Linux
- a Visual Studio 2007 build system for Windows
- Windows .exe executable files
- utility .h functions




## Contents



### `examples` directory

The `examples` directory contains C/C++ example programs, Windows .exe executable files, utility C header files, and the build systems for both Windows and Mac/Linux.

The example programs fall under the following structure:

examples
    Contains examples showing the LJM Easy functions for performing
    device operations.

    ain
        Contains examples showing how to perform analog input readings and
        configurations.

    config
        Contains examples showing how to read and write device configurations,
        including device name and power configurations.

    dio
        Contains examples showing how to read and write digital IOs.

    ethernet
        Contains examples showing how to read and write Ethernet configurations.

    testing
        Contains a LJM_eNames speed test.

    utilities
        Contains miscellaneous programs, including a T7 TCP configurer, device
        info dislayer, a stream example, and demonstrations of functions such
        as LJM_ListAll, LJM_WriteRaw/LJM_ReadRaw, LJM_NamesToAddresses,
        LJM_ErrorToString, and the LJM library config functions.

    watchdog
        Contains examples showing how to read and write watchdog configurations.

    wifi
        Contains examples showing how to read and write WiFi configurations and
        properties.


#### Utility functions

There are two utility function .h header files, LJM_Utilities.h and LJM_StreamUtilities.h.

LJM_Utilities.h is located in the `examples` directory and contains general-purpose functions which help to simplify the logic of the example programs. For example, the `WriteNameOrDie` function is a wrapper function for `LJM_eWriteName` that simply calls `LJM_eWriteName`, and if any error occurs, it prints the error using `LJM_ErrorToString` then exits with an error status.

LJM_StreamUtilities.h is located in the `examples/stream` directory and contains stream-related functions.


#### Build systems

Windows: The `examples\visual_studio_2008` directory contains a .sln and a .vcproj file for each example program.

Mac/Linux: Each directory in `examples/` contains a `make.sh` script that will run the corresponding SConstruct file. Additionally, the script `examples/make_all.sh` will call all the `make.sh` scripts.



### LabJackMModbusMap.h

LabJackMModbusMap.h contains definitions describing the Modbus map used with LJM-supported devices.



### scons-local-2.1.0/

SConstruct is a Python-based build system. A local copy is included in `scons-local-2.1.0`, though you will need Python installed.


