VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "eFunctions Example"
   ClientHeight    =   5220
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   6765
   LinkTopic       =   "Form1"
   ScaleHeight     =   5220
   ScaleWidth      =   6765
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox output 
      Height          =   4095
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      Text            =   "LJM_VB6_eFunctions.frx":0000
      Top             =   960
      Width           =   6495
   End
   Begin VB.CommandButton Run 
      Caption         =   "Run"
      Height          =   495
      Left            =   5280
      TabIndex        =   0
      Top             =   240
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'------------------------------------------------------------------------------
' LJM_VB6_eFunctions
'
' Demonstrates easy functions usage.
'
' support@labjack.com
'------------------------------------------------------------------------------
Option Explicit

Sub displayHandleInfo(ByVal lngHandle As Long)
    Dim lngDevType As Long
    Dim lngConType As Long
    Dim lngSerNum As Long
    Dim lngIPAddr As Long
    Dim lngPort As Long
    Dim lngMaxBytesPerMB As Long
    Dim strIPAddr As String * LJM_IPv4_STRING_SIZE
    Dim lngError As Long

    lngError = LJM_GetHandleInfo(lngHandle, lngDevType, lngConType, lngSerNum, lngIPAddr, lngPort, lngMaxBytesPerMB)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    lngError = LJM_NumberToIP(lngIPAddr, strIPAddr)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    
    output.Text = output.Text & "Opened a LabJack with Device type: " & Str$(lngDevType) & ", Connection type: " & Str$(lngConType) & "," & vbCrLf
    output.Text = output.Text & "Serial number: " & Str$(lngSerNum) & ", IP address: " & strIPAddr
    output.Text = output.Text & ", Port: " & Str$(lngPort) & "," & vbCrLf
    output.Text = output.Text & "Max bytes per MB: " & Str$(lngMaxBytesPerMB) & vbCrLf
End Sub

Public Sub Run_Click()
    Dim lngNumFrames As Long
    Dim lngHandle As Long
    Dim strName As String
    Dim dblValue As Double
    Dim strNames(2) As String
    Dim dblValues(2) As Double
    Dim lngAddress As Long
    Dim lngDataType As Long
    Dim lngAddresses(2) As Long
    Dim lngWrites(2) As Long
    Dim lngNumValues(2) As Long
    Dim lngDataTypes(2) As Long
    Dim lngError As Long
    Dim lngErrorAddress As Long
    Dim strErrorAddress As String
    Dim strError As String * LJM_MAX_NAME_SIZE
    Dim i As Integer
    Dim strTemp As String
    
    lngErrorAddress = -1
    strErrorAddress = ""
    
    On Error GoTo ErrorMessage
    
    'Get the LJM driver version.
    output.Text = "LJM Library Version = "
    lngError = LJM_ReadLibraryConfigS("LJM_LIBRARY_VERSION", dblValue)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    output.Text = output.Text & Str$(dblValue) & vbCrLf & vbCrLf
    
    'Open the first found device.
    lngError = LJM_OpenS("ANY", "ANY", "ANY", lngHandle)
    'lngError = LJM_Open(LJM_dtANY, LJM_ctANY, LJM_idANY, lngHandle)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    
    'Display the device information from the handle
    displayHandleInfo (lngHandle)
    
    ' Name functions '
    
    'Write DAC0
    strName = "DAC0"
    dblValue = 2.5 '2.5 V
    output.Text = output.Text & vbCrLf & "LJM_eWriteName: " & vbCrLf
    lngError = LJM_eWriteName(lngHandle, strName, dblValue)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    output.Text = output.Text & "    " & strName & " = " & Str$(dblValue) & " V" & vbCrLf
    
    'Read SERIAL_NUMBER
    output.Text = output.Text & vbCrLf & "LJM_eReadName: "
    strName = "SERIAL_NUMBER"
    lngError = LJM_eReadName(lngHandle, strName, dblValue)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    output.Text = output.Text & vbCrLf & "    " & strName & " = " & Str$(dblValue) & vbCrLf
    
    'Write DAC0 and TEST_UINT16
    output.Text = output.Text & vbCrLf & "LJM_eWriteNames: " & vbCrLf
    lngNumFrames = 2
    strNames(0) = "DAC0"
    strNames(1) = "TEST_UINT16"
    dblValues(0) = 2.5 '2.5 V
    dblValues(1) = 13245
    lngError = LJM_eWriteNames(lngHandle, lngNumFrames, strNames, dblValues, lngErrorAddress)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    For i = 0 To lngNumFrames - 1
        output.Text = output.Text & "    " & strNames(i) & " = " & Str$(dblValues(i)) & vbCrLf
    Next i
    
    'Read SERIAL_NUMBER, PRODUCT_ID, and FIRMWARE_VERSION
    output.Text = output.Text & vbCrLf & "LJM_eReadNames: " & vbCrLf
    lngNumFrames = 3
    strNames(0) = "SERIAL_NUMBER"
    strNames(1) = "PRODUCT_ID"
    strNames(2) = "FIRMWARE_VERSION"
    lngError = LJM_eReadNames(lngHandle, lngNumFrames, strNames, dblValues, lngErrorAddress)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    For i = 0 To lngNumFrames - 1
        output.Text = output.Text & "    " & strNames(i) & " = " & Str$(dblValues(i)) & vbCrLf
    Next i
    
    'Set DAC0 and TEST_UINT16, and read TEST_UINT16
    output.Text = output.Text & vbCrLf & "LJM_eNames: " & vbCrLf
    lngNumFrames = 3
    strNames(0) = "DAC0"
    strNames(1) = "TEST_UINT16"
    strNames(2) = "TEST_UINT16"
    lngWrites(0) = LJM_WRITE
    lngWrites(1) = LJM_WRITE
    lngWrites(2) = LJM_READ
    lngNumValues(0) = 1
    lngNumValues(1) = 1
    lngNumValues(2) = 1
    dblValues(0) = 2.5 '2.5 V
    dblValues(1) = 12345
    dblValues(2) = 0
    lngError = LJM_eNames(lngHandle, 3, strNames, lngWrites, lngNumValues, dblValues, lngErrorAddress)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    For i = 0 To lngNumFrames - 1
        strTemp = ""
        If lngWrites(i) = LJM_WRITE Then
            strTemp = "WRITE"
        Else
            strTemp = "READ"
        End If
        output.Text = output.Text & "    " & strNames(i) & " (" & strTemp & ") = " & Str$(dblValues(i)) & vbCrLf
    Next i
    
    
    ' Address Functions '
    
    'Write DAC0
    output.Text = output.Text & vbCrLf & "LJM_eWriteAddress: " & vbCrLf
    lngAddress = 1000
    lngDataType = LJM_FLOAT32
    dblValue = 2.5 '2.5 V
    lngError = LJM_eWriteAddress(lngHandle, lngAddress, lngDataType, dblValue)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    output.Text = output.Text & "    " & Str$(lngAddress) & " = " & Str$(dblValue) & " V" & vbCrLf

    'Read SERIAL_NUMBER
    output.Text = output.Text & vbCrLf & "LJM_eReadAddress: " & vbCrLf
    lngAddress = 60028
    lngDataType = LJM_UINT32
    lngError = LJM_eReadAddress(lngHandle, lngAddress, lngDataType, dblValue)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    output.Text = output.Text & "    " & Str$(lngAddress) & " = " & Str$(dblValue) & vbCrLf
   
    lngErrorAddress = -1

    'Write DAC0 and TEST_UINT16
    output.Text = output.Text & vbCrLf & "LJM_eWriteAddresses: " & vbCrLf
    lngNumFrames = 2
    lngAddresses(0) = 1000
    lngAddresses(1) = 55110
    lngDataTypes(0) = LJM_FLOAT32
    lngDataTypes(1) = LJM_UINT16
    dblValues(0) = 2.5 '2.5 V
    dblValues(1) = 12345
    lngError = LJM_eWriteAddresses(lngHandle, lngNumFrames, lngAddresses(0), lngDataTypes(0), dblValues(0), lngErrorAddress)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    For i = 0 To lngNumFrames - 1
        output.Text = output.Text & "    " & Str$(lngAddresses(i)) & " = " & Str$(dblValues(i)) & vbCrLf
    Next i

    'Read SERIAL_NUMBER, PRODUCT_ID, and FIRMWARE_VERSION
    output.Text = output.Text & vbCrLf & "LJM_eReadAddresses: " & vbCrLf
    lngNumFrames = 3
    lngAddresses(0) = 60028
    lngAddresses(1) = 60000
    lngAddresses(2) = 60004
    lngDataTypes(0) = LJM_UINT32
    lngDataTypes(1) = LJM_FLOAT32
    lngDataTypes(2) = LJM_FLOAT32
    lngError = LJM_eReadAddresses(lngHandle, lngNumFrames, lngAddresses(0), lngDataTypes(0), dblValues(0), lngErrorAddress)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    For i = 0 To lngNumFrames - 1
        output.Text = output.Text & "    " & Str$(lngAddresses(i)) & " = " & Str$(dblValues(i)) & ", " & vbCrLf
    Next i
    output.Text = output.Text & vbCrLf

    'Set DAC0 and TEST_UINT16, and read TEST_UINT16
    output.Text = output.Text & vbCrLf & "LJM_eAddresses: " & vbCrLf
    lngNumFrames = 3
    lngAddresses(0) = 1000
    lngAddresses(1) = 55110
    lngAddresses(2) = 55110
    lngDataTypes(0) = LJM_FLOAT32
    lngDataTypes(1) = LJM_UINT16
    lngDataTypes(2) = LJM_UINT16
    lngWrites(0) = LJM_WRITE
    lngWrites(1) = LJM_WRITE
    lngWrites(2) = LJM_READ
    lngNumValues(0) = 1
    lngNumValues(1) = 1
    lngNumValues(2) = 1
    dblValues(0) = 2.5 '2.5 V
    dblValues(1) = 12345
    dblValues(2) = 0
    lngError = LJM_eAddresses(lngHandle, lngNumFrames, lngAddresses(0), lngDataTypes(0), lngWrites(0), lngNumValues(0), dblValues(0), lngErrorAddress)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    For i = 0 To lngNumFrames - 1
        strTemp = ""
        If lngWrites(i) = LJM_WRITE Then
            strTemp = "WRITE"
        Else
            strTemp = "READ"
        End If
        output.Text = output.Text & "    " & Str$(lngAddresses(i)) & " (" & strTemp & ") = " & Str$(dblValues(i)) & ", " & vbCrLf
    Next i
    
    lngError = LJM_Close(lngHandle)
    If lngError <> LJME_NOERROR Then Err.Raise lngError + 50000 'Adding 50000 makes sure Labjack errors are recognized by VB as "user-defined"
    
    output.Text = output.Text & vbCrLf & "Done"
    
    Exit Sub
    
ErrorMessage:
    If Err.Number > 50000 Then
        'LabJack error
        If lngErrorAddress < 0 Then strErrorAddress = " at address " & Str$(lngErrorAddress)
        LJM_ErrorToString Err.Number - 50000, strError
        output.Text = output.Text & vbCrLf & "LJM Error #" & Str$(Err.Number - 50000) & " " & strError & strErrorAddress
        MsgBox "LJM Error #" & Str$(Err.Number - 50000) & " " & strError & strErrorAddress
    ElseIf Err.Number > 0 Then
        'VB error
        output.Text = output.Text & vbCrLf & "VB error: Error #" & Str$(Err.Number)
        MsgBox "VB error: Error #" & Str$(Err.Number)
    End If
    
    LJM_CloseAll
    
    output.Text = output.Text & vbCrLf & vbCrLf & "Done"
    
    Exit Sub
End Sub
