/*
 * Decompiled with CFR 0.152.
 */
package com.teravation.labjack;

import com.teravation.labjack.LabJack;
import com.teravation.labjack.LabJackDriver;
import com.teravation.labjack.LabJackException;

public class LabJackFactory {
    private static LabJack[] labjacks;

    public LabJack getLabJack(int serialNumber) throws LabJackException {
        LabJack labjack = null;
        LabJack[] labjacks = this.getLabJacks();
        int i = 0;
        while (i < labjacks.length) {
            if (labjacks[i].getSerialNumber() == serialNumber) {
                labjack = labjacks[i];
                break;
            }
            ++i;
        }
        return labjack;
    }

    public LabJack[] getLabJacks() throws LabJackException {
        return this.getLabJacks(false);
    }

    public LabJack[] getLabJacks(boolean find) throws LabJackException {
        if (find || labjacks == null) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows") || osName.equals("Linux") || osName.equals("Mac OS X")) {
                labjacks = LabJackDriver.getAll();
            } else {
                System.out.println(osName);
                throw new LabJackException(-1);
            }
        }
        return labjacks;
    }

    public float getDriverVersion() throws LabJackException {
        return LabJackDriver.getDriverVersion();
    }
}

