/*
 * Decompiled with CFR 0.152.
 */
package com.teravation.labjack;

import com.teravation.labjack.LabJack;
import com.teravation.labjack.LabJackException;
import com.teravation.labjack.LabJackScan;

public abstract class LabJackImpl
implements LabJack {
    protected static LabJack[] labjacks;
    protected int productId;
    protected int serialNumber;
    protected int localId;
    protected float[] analogInputValues = new float[12];
    protected long[] analogInputGains = new long[4];
    protected float[] analogOutputValues = new float[2];
    protected long digitalDValues = 0L;
    protected long digitalDDirections = 0L;
    protected long digitalIOValues = 0L;
    protected long digitalIODirections = 0L;
    protected long counter = 0L;
    protected float tempC = 0.0f;
    protected float tempF = 0.0f;
    protected float humidity = 0.0f;
    protected float firmwareVersion = 0.0f;
    protected LabJackScan scan = null;

    public float getAI(int channel) throws LabJackException {
        if (channel < 0 || channel >= 8) {
            throw new LabJackException(21);
        }
        return this.analogInputValues[channel];
    }

    public float getAO(int channel) throws LabJackException {
        if (channel < 0 || channel >= 2) {
            throw new LabJackException(21);
        }
        return this.analogOutputValues[channel];
    }

    public long getCounter() {
        return this.counter;
    }

    public boolean getD(int channel) throws LabJackException {
        boolean value = false;
        if (channel < 0 || channel >= 16) {
            throw new LabJackException(21);
        }
        return this.getDigitalDValue(channel);
    }

    public float getDifferentialAI(int channel) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        return this.analogInputValues[8 + channel];
    }

    public int getDifferentialAIGain(int channel) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        return (int)this.analogInputGains[channel];
    }

    protected boolean getDigitalDValue(int bit) {
        return (this.digitalDValues & (long)(1 << bit)) > 0L;
    }

    protected boolean getDigitalIOValue(int bit) {
        return (this.digitalIOValues & (long)(1 << bit)) > 0L;
    }

    public float getHumidity() {
        return this.humidity;
    }

    public boolean getIO(int channel) throws LabJackException {
        boolean value = false;
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        return this.getDigitalIOValue(channel);
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public float getTempC() {
        return this.tempC;
    }

    public float getTempF() {
        return this.tempF;
    }

    public boolean isDForOutput(int bit) {
        return (this.digitalDDirections & (long)(1 << bit)) > 0L;
    }

    public boolean isIOForOutput(int bit) {
        return (this.digitalIODirections & (long)(1 << bit)) > 0L;
    }

    public void setAO(int channel, float value) throws LabJackException {
        if (channel < 0 || channel >= 2) {
            throw new LabJackException(21);
        }
        this.analogOutputValues[channel] = value;
    }

    public void setD(int channel, boolean value) throws LabJackException {
        if (channel < 0 || channel >= 16) {
            throw new LabJackException(21);
        }
        if (!this.isDForOutput(channel)) {
            throw new LabJackException(1000);
        }
        this.setDigitalDValue(channel, value);
    }

    public void setDForInput(int channel) throws LabJackException {
        if (channel < 0 || channel >= 16) {
            throw new LabJackException(21);
        }
        this.digitalDDirections &= (long)(~(1 << channel));
    }

    public void setDForOutput(int channel) throws LabJackException {
        if (channel < 0 || channel >= 16) {
            throw new LabJackException(21);
        }
        this.digitalDDirections |= (long)(1 << channel);
    }

    public void setDifferentialAIGain(int channel, int gain) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        if (gain < 0 || gain > 7) {
            throw new LabJackException(17);
        }
        this.analogInputGains[channel] = gain;
    }

    protected void setDigitalDValue(int bit, boolean value) {
        this.digitalDValues = value ? (this.digitalDValues |= (long)(1 << bit)) : (this.digitalDValues &= (long)(~(1 << bit)));
    }

    protected void setDigitalIOValue(int bit, boolean value) {
        this.digitalIOValues = value ? (this.digitalIOValues |= (long)(1 << bit)) : (this.digitalIOValues &= (long)(~(1 << bit)));
    }

    public void setIO(int channel, boolean value) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        if (!this.isIOForOutput(channel)) {
            throw new LabJackException(1000);
        }
        this.setDigitalIOValue(channel, value);
    }

    public void setIOForInput(int channel) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        this.digitalIODirections &= (long)(~(1 << channel));
    }

    public void setIOForOutput(int channel) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        this.digitalIODirections |= (long)(1 << channel);
    }

    public void setLocalId(int newLocalId) {
        this.localId = newLocalId;
    }

    protected void setProductId(int newProductId) {
        this.productId = newProductId;
    }

    protected void setSerialNumber(int newSerialNumber) {
        this.serialNumber = newSerialNumber;
    }

    protected void setTempF(float newTempF) {
        this.tempF = newTempF;
    }

    protected void setTempC(float newTempC) {
        this.tempC = newTempC;
    }

    protected void setCounter(int newCounter) {
        this.counter = newCounter;
    }

    protected void setHumidity(float newHumidity) {
        this.humidity = newHumidity;
    }

    public float getFirmwareVersion() {
        return this.firmwareVersion;
    }

    protected void setFirmwareVersion(float firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    private String getStatusString() {
        StringBuffer sb = new StringBuffer(21);
        try {
            int io = 0;
            while (io < 4) {
                if (this.isIOForOutput(io)) {
                    sb.append(this.getIO(io) ? "X" : "O");
                } else {
                    sb.append(this.getIO(io) ? "x" : "o");
                }
                ++io;
            }
            sb.append(" ");
            int d = 0;
            while (d < 16) {
                if (this.isDForOutput(d)) {
                    sb.append(this.getD(d) ? "X" : "O");
                } else {
                    sb.append(this.getD(d) ? "x" : "o");
                }
                ++d;
            }
        }
        catch (LabJackException labJackException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String toString() {
        return "LabJack (" + this.getSerialNumber() + ")";
    }

    public LabJackScan getScan() {
        return this.scan;
    }

    public void setPulse(float pulseWidth, float pulseSpace) {
        this.setPulseWidth(pulseWidth);
        this.setPulseSpace(pulseSpace);
    }

    public abstract void updateAI(int var1) throws LabJackException;

    public abstract void updateAll() throws LabJackException;

    public abstract void updateAll(boolean var1) throws LabJackException;

    public abstract void updateAllAIs() throws LabJackException;

    public abstract void updateAllAOsAndDigitals() throws LabJackException;

    public abstract void updateAllAOsAndDigitals(boolean var1) throws LabJackException;

    public abstract void updateAllDifferentialAIs() throws LabJackException;

    public abstract void updateAO(int var1) throws LabJackException;

    public abstract void updateCounter() throws LabJackException;

    public abstract void updateCounter(boolean var1) throws LabJackException;

    public abstract void updateD(int var1) throws LabJackException;

    public abstract void updateDifferentialAI(int var1) throws LabJackException;

    public abstract void updateEnvironmentals() throws LabJackException;

    public abstract void updateHighAIs() throws LabJackException;

    public abstract void updateIO(int var1) throws LabJackException;

    public abstract void updateLowAIs() throws LabJackException;

    public abstract float updateScanFromBurst(long[] var1, float var2, int var3) throws LabJackException;

    public abstract float updateScanFromBurst(long[] var1, float var2, int var3, int var4, boolean var5, boolean var6, boolean var7, long var8, boolean var10) throws LabJackException;

    public abstract void updateLocalId() throws LabJackException;

    public abstract void reset() throws LabJackException;

    public abstract void reenumerate() throws LabJackException;

    public abstract void updateFirmwareVersion() throws LabJackException;

    public abstract void setPulseWidth(float var1);

    public abstract void setPulseSpace(float var1);

    public abstract float getPulseWidth();

    public abstract float getPulseSpace();

    public abstract void updatePulse(int var1, int var2) throws LabJackException;

    public abstract void updatePulse(boolean[] var1, int var2) throws LabJackException;

    public abstract void updatePulse(boolean[] var1, int var2, boolean var3) throws LabJackException;

    public abstract void updatePulseAsynch(int var1, int var2) throws LabJackException;

    public abstract void updatePulseAsynch(boolean[] var1, int var2) throws LabJackException;

    public abstract void updatePulseAsynch(boolean[] var1, int var2, boolean var3) throws LabJackException;

    public abstract void updatePulseAsynchFinish(int var1) throws LabJackException;

    public abstract float updateStreamStart(long[] var1, float var2, boolean var3) throws LabJackException;

    public abstract float updateStreamStart(long[] var1, float var2) throws LabJackException;

    public abstract void updateStreamClear() throws LabJackException;

    public abstract void updateScanFromStream(int var1) throws LabJackException;

    public abstract void updateScanFromStream(int var1, int var2) throws LabJackException;
}

