//Author: LabJack
//July 18, 2007
//This example program calls the CommConfig function and reads the various  
//configuration settings associated with the Comm processor

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using LabJack;

namespace CommConfigUSB
{
	public class CommConfigUSBForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label errorLabel;
		private System.Windows.Forms.TextBox errorBox;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage CommConfig0Tab;
		private System.Windows.Forms.TabPage CommConfig1Tab;
		private System.Windows.Forms.TextBox commPowerLevelBox;
		private System.Windows.Forms.Label commPowerLevelText;
		private System.Windows.Forms.TextBox subnetBox;
		private System.Windows.Forms.TextBox gatewayBox;
		private System.Windows.Forms.TextBox localIDBox;
		private System.Windows.Forms.Label subnetText;
		private System.Windows.Forms.Label gatewayText;
		private System.Windows.Forms.Label localIDText;
		private System.Windows.Forms.Button commConfigButton;
		private System.Windows.Forms.TextBox dhcpEnabledBox;
		private System.Windows.Forms.Label dhcpEnabledText;
		private System.Windows.Forms.TextBox prodIDBox;
		private System.Windows.Forms.Label prodIDText;
		private System.Windows.Forms.TextBox macAddrBox;
		private System.Windows.Forms.Label macAddrText;
		private System.Windows.Forms.TextBox commFWVerBox;
		private System.Windows.Forms.TextBox hwVerBox;
		private System.Windows.Forms.Label commFWVerText;
		private System.Windows.Forms.Label hwVerText;
		private System.Windows.Forms.TextBox portBBox;
		private System.Windows.Forms.TextBox portABox;
		private System.Windows.Forms.Label portAText;
		private System.Windows.Forms.Label portBText;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.Label idLabel;
		private System.Windows.Forms.NumericUpDown idBox;
		private System.Windows.Forms.TextBox ipBox;
		private System.Windows.Forms.Label ipText;
		private UE9 ue9Dev;

		public CommConfigUSBForm()
		{
			InitializeComponent();
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.idLabel = new System.Windows.Forms.Label();
			this.errorLabel = new System.Windows.Forms.Label();
			this.errorBox = new System.Windows.Forms.TextBox();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.CommConfig0Tab = new System.Windows.Forms.TabPage();
			this.ipBox = new System.Windows.Forms.TextBox();
			this.ipText = new System.Windows.Forms.Label();
			this.commPowerLevelBox = new System.Windows.Forms.TextBox();
			this.commPowerLevelText = new System.Windows.Forms.Label();
			this.subnetBox = new System.Windows.Forms.TextBox();
			this.gatewayBox = new System.Windows.Forms.TextBox();
			this.localIDBox = new System.Windows.Forms.TextBox();
			this.subnetText = new System.Windows.Forms.Label();
			this.gatewayText = new System.Windows.Forms.Label();
			this.localIDText = new System.Windows.Forms.Label();
			this.CommConfig1Tab = new System.Windows.Forms.TabPage();
			this.dhcpEnabledBox = new System.Windows.Forms.TextBox();
			this.dhcpEnabledText = new System.Windows.Forms.Label();
			this.prodIDBox = new System.Windows.Forms.TextBox();
			this.prodIDText = new System.Windows.Forms.Label();
			this.macAddrBox = new System.Windows.Forms.TextBox();
			this.macAddrText = new System.Windows.Forms.Label();
			this.commFWVerBox = new System.Windows.Forms.TextBox();
			this.hwVerBox = new System.Windows.Forms.TextBox();
			this.commFWVerText = new System.Windows.Forms.Label();
			this.hwVerText = new System.Windows.Forms.Label();
			this.portBBox = new System.Windows.Forms.TextBox();
			this.portABox = new System.Windows.Forms.TextBox();
			this.portAText = new System.Windows.Forms.Label();
			this.portBText = new System.Windows.Forms.Label();
			this.commConfigButton = new System.Windows.Forms.Button();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.idBox = new System.Windows.Forms.NumericUpDown();
			// 
			// idLabel
			// 
			this.idLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.idLabel.Location = new System.Drawing.Point(8, 200);
			this.idLabel.Size = new System.Drawing.Size(64, 32);
			this.idLabel.Text = "UE9 Local ID :";
			// 
			// errorLabel
			// 
			this.errorLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.errorLabel.Location = new System.Drawing.Point(8, 240);
			this.errorLabel.Size = new System.Drawing.Size(40, 20);
			this.errorLabel.Text = "Error:";
			// 
			// errorBox
			// 
			this.errorBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold);
			this.errorBox.Location = new System.Drawing.Point(56, 240);
			this.errorBox.ReadOnly = true;
			this.errorBox.Size = new System.Drawing.Size(176, 21);
			this.errorBox.Text = "";
			// 
			// tabControl1
			// 
			this.tabControl1.Controls.Add(this.CommConfig0Tab);
			this.tabControl1.Controls.Add(this.CommConfig1Tab);
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(240, 192);
			// 
			// CommConfig0Tab
			// 
			this.CommConfig0Tab.Controls.Add(this.ipBox);
			this.CommConfig0Tab.Controls.Add(this.ipText);
			this.CommConfig0Tab.Controls.Add(this.commPowerLevelBox);
			this.CommConfig0Tab.Controls.Add(this.commPowerLevelText);
			this.CommConfig0Tab.Controls.Add(this.subnetBox);
			this.CommConfig0Tab.Controls.Add(this.gatewayBox);
			this.CommConfig0Tab.Controls.Add(this.localIDBox);
			this.CommConfig0Tab.Controls.Add(this.subnetText);
			this.CommConfig0Tab.Controls.Add(this.gatewayText);
			this.CommConfig0Tab.Controls.Add(this.localIDText);
			this.CommConfig0Tab.Location = new System.Drawing.Point(4, 4);
			this.CommConfig0Tab.Size = new System.Drawing.Size(232, 166);
			this.CommConfig0Tab.Text = "Commconfig(1)";
			// 
			// ipBox
			// 
			this.ipBox.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular);
			this.ipBox.Location = new System.Drawing.Point(88, 72);
			this.ipBox.ReadOnly = true;
			this.ipBox.Size = new System.Drawing.Size(120, 21);
			this.ipBox.Text = "";
			// 
			// ipText
			// 
			this.ipText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ipText.Location = new System.Drawing.Point(8, 72);
			this.ipText.Size = new System.Drawing.Size(80, 16);
			this.ipText.Text = "IP Address:";
			// 
			// commPowerLevelBox
			// 
			this.commPowerLevelBox.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular);
			this.commPowerLevelBox.Location = new System.Drawing.Point(72, 40);
			this.commPowerLevelBox.ReadOnly = true;
			this.commPowerLevelBox.Size = new System.Drawing.Size(72, 21);
			this.commPowerLevelBox.Text = "";
			// 
			// commPowerLevelText
			// 
			this.commPowerLevelText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.commPowerLevelText.Location = new System.Drawing.Point(8, 40);
			this.commPowerLevelText.Size = new System.Drawing.Size(56, 16);
			this.commPowerLevelText.Text = "Pwr Lvl:";
			// 
			// subnetBox
			// 
			this.subnetBox.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular);
			this.subnetBox.Location = new System.Drawing.Point(72, 136);
			this.subnetBox.ReadOnly = true;
			this.subnetBox.Size = new System.Drawing.Size(120, 21);
			this.subnetBox.Text = "";
			// 
			// gatewayBox
			// 
			this.gatewayBox.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular);
			this.gatewayBox.Location = new System.Drawing.Point(72, 104);
			this.gatewayBox.ReadOnly = true;
			this.gatewayBox.Size = new System.Drawing.Size(120, 21);
			this.gatewayBox.Text = "";
			// 
			// localIDBox
			// 
			this.localIDBox.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular);
			this.localIDBox.Location = new System.Drawing.Point(72, 8);
			this.localIDBox.ReadOnly = true;
			this.localIDBox.Size = new System.Drawing.Size(56, 21);
			this.localIDBox.Text = "";
			// 
			// subnetText
			// 
			this.subnetText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.subnetText.Location = new System.Drawing.Point(8, 136);
			this.subnetText.Size = new System.Drawing.Size(56, 16);
			this.subnetText.Text = "Subnet:";
			// 
			// gatewayText
			// 
			this.gatewayText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.gatewayText.Location = new System.Drawing.Point(8, 104);
			this.gatewayText.Size = new System.Drawing.Size(64, 16);
			this.gatewayText.Text = "Gateway:";
			// 
			// localIDText
			// 
			this.localIDText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.localIDText.Location = new System.Drawing.Point(8, 8);
			this.localIDText.Size = new System.Drawing.Size(64, 16);
			this.localIDText.Text = "Local ID:";
			// 
			// CommConfig1Tab
			// 
			this.CommConfig1Tab.Controls.Add(this.dhcpEnabledBox);
			this.CommConfig1Tab.Controls.Add(this.dhcpEnabledText);
			this.CommConfig1Tab.Controls.Add(this.prodIDBox);
			this.CommConfig1Tab.Controls.Add(this.prodIDText);
			this.CommConfig1Tab.Controls.Add(this.macAddrBox);
			this.CommConfig1Tab.Controls.Add(this.macAddrText);
			this.CommConfig1Tab.Controls.Add(this.commFWVerBox);
			this.CommConfig1Tab.Controls.Add(this.hwVerBox);
			this.CommConfig1Tab.Controls.Add(this.commFWVerText);
			this.CommConfig1Tab.Controls.Add(this.hwVerText);
			this.CommConfig1Tab.Controls.Add(this.portBBox);
			this.CommConfig1Tab.Controls.Add(this.portABox);
			this.CommConfig1Tab.Controls.Add(this.portAText);
			this.CommConfig1Tab.Controls.Add(this.portBText);
			this.CommConfig1Tab.Location = new System.Drawing.Point(4, 4);
			this.CommConfig1Tab.Size = new System.Drawing.Size(232, 166);
			this.CommConfig1Tab.Text = "CommConfig(2)";
			// 
			// dhcpEnabledBox
			// 
			this.dhcpEnabledBox.Location = new System.Drawing.Point(92, 105);
			this.dhcpEnabledBox.ReadOnly = true;
			this.dhcpEnabledBox.Size = new System.Drawing.Size(88, 22);
			this.dhcpEnabledBox.Text = "";
			// 
			// dhcpEnabledText
			// 
			this.dhcpEnabledText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.dhcpEnabledText.Location = new System.Drawing.Point(12, 105);
			this.dhcpEnabledText.Size = new System.Drawing.Size(64, 32);
			this.dhcpEnabledText.Text = "DHCP Enabled:";
			// 
			// prodIDBox
			// 
			this.prodIDBox.Location = new System.Drawing.Point(92, 137);
			this.prodIDBox.ReadOnly = true;
			this.prodIDBox.Size = new System.Drawing.Size(88, 22);
			this.prodIDBox.Text = "";
			// 
			// prodIDText
			// 
			this.prodIDText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.prodIDText.Location = new System.Drawing.Point(12, 137);
			this.prodIDText.Size = new System.Drawing.Size(80, 16);
			this.prodIDText.Text = "Product ID:                       ";
			// 
			// macAddrBox
			// 
			this.macAddrBox.Location = new System.Drawing.Point(60, 73);
			this.macAddrBox.ReadOnly = true;
			this.macAddrBox.Size = new System.Drawing.Size(120, 22);
			this.macAddrBox.Text = "";
			// 
			// macAddrText
			// 
			this.macAddrText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.macAddrText.Location = new System.Drawing.Point(12, 73);
			this.macAddrText.Size = new System.Drawing.Size(40, 32);
			this.macAddrText.Text = "MAC Addr:";
			// 
			// commFWVerBox
			// 
			this.commFWVerBox.Location = new System.Drawing.Point(164, 41);
			this.commFWVerBox.ReadOnly = true;
			this.commFWVerBox.Size = new System.Drawing.Size(56, 22);
			this.commFWVerBox.Text = "";
			// 
			// hwVerBox
			// 
			this.hwVerBox.Location = new System.Drawing.Point(44, 41);
			this.hwVerBox.ReadOnly = true;
			this.hwVerBox.Size = new System.Drawing.Size(56, 22);
			this.hwVerBox.Text = "";
			// 
			// commFWVerText
			// 
			this.commFWVerText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.commFWVerText.Location = new System.Drawing.Point(108, 41);
			this.commFWVerText.Size = new System.Drawing.Size(56, 32);
			this.commFWVerText.Text = "Comm FW Ver:";
			// 
			// hwVerText
			// 
			this.hwVerText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.hwVerText.Location = new System.Drawing.Point(12, 41);
			this.hwVerText.Size = new System.Drawing.Size(32, 32);
			this.hwVerText.Text = "HW Ver:";
			// 
			// portBBox
			// 
			this.portBBox.Location = new System.Drawing.Point(164, 9);
			this.portBBox.ReadOnly = true;
			this.portBBox.Size = new System.Drawing.Size(56, 22);
			this.portBBox.Text = "";
			// 
			// portABox
			// 
			this.portABox.Location = new System.Drawing.Point(52, 9);
			this.portABox.ReadOnly = true;
			this.portABox.Size = new System.Drawing.Size(56, 22);
			this.portABox.Text = "";
			// 
			// portAText
			// 
			this.portAText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.portAText.Location = new System.Drawing.Point(12, 9);
			this.portAText.Size = new System.Drawing.Size(32, 32);
			this.portAText.Text = "Port A:";
			this.portAText.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// portBText
			// 
			this.portBText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.portBText.Location = new System.Drawing.Point(124, 9);
			this.portBText.Size = new System.Drawing.Size(32, 32);
			this.portBText.Text = "Port B:";
			this.portBText.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// commConfigButton
			// 
			this.commConfigButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.commConfigButton.Location = new System.Drawing.Point(152, 200);
			this.commConfigButton.Size = new System.Drawing.Size(80, 24);
			this.commConfigButton.Text = "Run";
			this.commConfigButton.Click += new System.EventHandler(this.commConfigButton_Click);
			// 
			// idBox
			// 
			this.idBox.Location = new System.Drawing.Point(80, 208);
			this.idBox.Maximum = new System.Decimal(new int[] {
																  255,
																  0,
																  0,
																  0});
			this.idBox.Minimum = new System.Decimal(new int[] {
																  1,
																  0,
																  0,
																  -2147483648});
			this.idBox.Size = new System.Drawing.Size(56, 20);
			this.idBox.Value = new System.Decimal(new int[] {
																1,
																0,
																0,
																-2147483648});
			// 
			// CommConfigUSBForm
			// 
			this.Controls.Add(this.idBox);
			this.Controls.Add(this.tabControl1);
			this.Controls.Add(this.idLabel);
			this.Controls.Add(this.errorLabel);
			this.Controls.Add(this.errorBox);
			this.Controls.Add(this.commConfigButton);
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "ue9CommConfig USB";
			this.Load += new System.EventHandler(this.CommConfigForm_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new CommConfigUSBForm());
		}

		private void CommConfigForm_Load(object sender, System.EventArgs e)
		{
		
		}

		private void commConfigButton_Click(object sender, System.EventArgs e)
		{
		
			int err = 0;
			Error errorText = new Error(); 
			ue9Dev = new UE9();
			errorBox.Text = "";
			localIDBox.Text = "";
			commPowerLevelBox.Text = "";
			gatewayBox.Text = "";
			subnetBox.Text = "";
			portABox.Text = "";
			portBBox.Text = "";
			hwVerBox.Text = "";
			commFWVerBox.Text = "";
			macAddrBox.Text = "";
			dhcpEnabledBox.Text = "";
			prodIDBox.Text = "";
			ipBox.Text = "";

			if((err = ue9Dev.openUSBConnection(Convert.ToInt32(idBox.Value))) < 0)
			{
				errorBox.Text = errorText.getError(err);
				return;
			}
			
			if( (err = commConfig_example()) < 0)
			{
				errorBox.Text = errorText.getError(err);
				ue9Dev.closeUSBConnection();				
				return;
			}
			
			if( (err = ue9Dev.closeUSBConnection()) < 0)
			{
				errorBox.Text = errorText.getError(err);
				return;
			}
		}

		private int commConfig_example()
		{
			byte []sendBuff = new byte[38];
			byte []recBuff = new byte[38];
			int i;
			ushort checksumTotal;
			char []str = new char[3];

			sendBuff[1] = (byte)(0x78);  //command byte
			sendBuff[2] = (byte)(0x10);  //number of data words
			sendBuff[3] = (byte)(0x01);  //extended command number

			//WriteMask, LocalID, PowerLevel, etc. are all passed a value of
			//zero since we only want to read Comm configuration settings, 
			//not change them
			for(i = 6; i < 38; i++)
				sendBuff[i] = (byte)(0x00);

			UE9.extendedChecksum(ref sendBuff,38);
  
			try
			{
				if(UE9.LJUSB_BulkWrite(ue9Dev.handle, UE9.UE9_PIPE_EP1_OUT, sendBuff, 38) != 38)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP1_IN, recBuff, 38) != 38)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -15;
			}
			
			checksumTotal = UE9.extendedChecksum16(recBuff, 38);
			if( (byte)((checksumTotal / 256) & 0xff) != recBuff[5])
				return -16;

			if( (byte)(checksumTotal & 0xff) != recBuff[4])
				return -16;

			if( UE9.extendedChecksum8(recBuff) != recBuff[0])
				return -17;

			if( recBuff[1] != (byte)(0x78) || recBuff[2] != (byte)(0x10) || recBuff[3] != (byte)(0x01) )
				return -10;

			localIDBox.Text = Convert.ToUInt32(recBuff[8]).ToString();

			commPowerLevelBox.Text = Convert.ToUInt32(recBuff[9]).ToString();			

			ipBox.Text = Convert.ToUInt32(recBuff[13]).ToString() + "."
				+ Convert.ToUInt32(recBuff[12]).ToString() + "."
				+ Convert.ToUInt32(recBuff[11]).ToString() + "."
				+ Convert.ToUInt32(recBuff[10]).ToString();
  
			gatewayBox.Text = Convert.ToUInt32(recBuff[17]).ToString() + "." 
				+ Convert.ToUInt32(recBuff[16]).ToString() + "." 
				+ Convert.ToUInt32(recBuff[15]).ToString() + "." 
				+ Convert.ToUInt32(recBuff[14]).ToString();			
			
			subnetBox.Text = Convert.ToUInt32(recBuff[21]).ToString() + "." 
				+ Convert.ToUInt32(recBuff[20]).ToString() + "." 
				+ Convert.ToUInt32(recBuff[19]).ToString() + "." 
				+ Convert.ToUInt32(recBuff[18]).ToString();			
			
			portABox.Text = Convert.ToUInt32(recBuff[22] + (recBuff[23] * 256 )).ToString();
			portBBox.Text = Convert.ToUInt32(recBuff[24] + (recBuff[25] * 256 )).ToString();
			dhcpEnabledBox.Text = Convert.ToUInt32(recBuff[26]).ToString();
			prodIDBox.Text = Convert.ToUInt32(recBuff[27]).ToString();			
			
			macAddrBox.Text = String.Format("{0:x2}", recBuff[33]) 
				+ String.Format("{0:x2}", recBuff[32])
				+ String.Format("{0:x2}", recBuff[31])
				+ String.Format("{0:x2}", recBuff[30])
				+ String.Format("{0:x2}", recBuff[29])
				+ String.Format("{0:x2}", recBuff[28]);
			
			hwVerBox.Text = string.Format("{0:f3}", (uint)recBuff[35]  + (double)recBuff[34] / 100.0);					
			commFWVerBox.Text = string.Format("{0:f3}", (uint)recBuff[37]  + (double)recBuff[36] / 100.0);					
			
			return 0;
		}
	}
}
